<?php
/*
Plugin Name: Asa Server Info
Description: Plugin to display Ark Survival Ascended server information.
Version: 0.2
Author: Sir Dodo
Website: https://www.dodokillers.com/plugins/
Discord: https://discord.gg/ffheUAFHUr
*/

function asasi_load_textdomain() {
    load_plugin_textdomain( 'asa-server-info', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'asasi_load_textdomain' );

require_once 'admin/admin.php';
require_once 'blocks/asa-server.php';

// Function to create pages automatically
function asasi_create_server_pages() {
    global $wpdb;

    // Get all servers from the database
    $servers = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}asa_servers");

    // Get all slugs of existing pages
    $existing_post_name = $wpdb->get_col("SELECT post_name FROM {$wpdb->prefix}posts WHERE post_type = 'page'");

    // Create pages for servers that are not present
    foreach ($servers as $server) {
		$server_name = "dk-asa-server-" . $server->ServerNumber;

        // Check if server slug already exists
		if (!in_array($server_name, $existing_post_name)) {
            // Create page for the server
			$page_content = sprintf("<!-- wp:asasi/server {\"server\":%d} -->", $server->ServerNumber);
            $page_id = wp_insert_post(array(
                'post_title' => '#' . sprintf("%02d", $server->ServerNumber) . ' - ' . $server->ServerName,
                'post_name' => "dk-asa-server-" . $server->ServerNumber,
                'post_type' => 'page',
                'post_status' => 'publish',
				'post_content' => $page_content,
            ));
        }
    }
}
add_action('init', 'asasi_create_server_pages');

function asasi_create_tables() {
    global $wpdb;

    // Get WordPress table prefix
    $prefix = $wpdb->prefix;

    // SQL query to create asa_servers table
    $asa_servers_table = "CREATE TABLE IF NOT EXISTS `{$prefix}asa_servers` (
      `ServerNumber` INT PRIMARY KEY,
      `ServerName` VARCHAR(255) NOT NULL,
      `ClusterNumber` INT NOT NULL,
      `ServerBMid` INT NOT NULL,
      `ServerRCON` INT NOT NULL,
      `ServerPassword` VARCHAR(30) NOT NULL,
      `ExpMulti` FLOAT NOT NULL,
      `TamingMulti` FLOAT NOT NULL,
      `GatheringMulti` FLOAT NOT NULL,
      `BreedingMulti` FLOAT NOT NULL,
      UNIQUE KEY `ServerNumber_UNIQUE` (`ServerNumber`),
      UNIQUE KEY `ServerBMid_UNIQUE` (`ServerBMid`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

    // SQL query to create asa_clusters table
    $asa_clusters_table = "CREATE TABLE IF NOT EXISTS `{$prefix}asa_clusters` (
      `ClusterNumber` INT AUTO_INCREMENT PRIMARY KEY,
      `ClusterName` VARCHAR(255) NOT NULL,
      `ExpMulti` FLOAT NOT NULL,
      `TamingMulti` FLOAT NOT NULL,
      `GatheringMulti` FLOAT NOT NULL,
      `BreedingMulti` FLOAT NOT NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

    // Execute SQL queries to create tables
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($asa_servers_table);
    dbDelta($asa_clusters_table);
}

// Call the function to create tables upon plugin activation
register_activation_hook(__FILE__, 'asasi_create_tables');
